-- Pane3 displays a list of HighScores for the stepchart that was played.

local args = ...
local player = args.player
local hsdata = args.hsdata

local pane = Def.ActorFrame{
	Name="HighScores",
	InitCommand=function(self)
		self:visible(false)
		self:y(_screen.cy - 62):zoom(0.8)
	end
}

-- row_height of a HighScore line
local rh
local listargs = { Player=player, RowHeight=rh}

-- less line spacing between HighScore rows to fit the horizontal line
rh = 20.25
listargs.RowHeight = rh

-- top 5 standard records
listargs.NumHighScores = 5
listargs.HSData = hsdata
pane[#pane+1] = LoadActor(THEME:GetPathB("", "_modules/HighScoreList_WF.lua"), listargs)

-- horizontal line visually separating standard records from itg records
pane[#pane+1] = Def.Quad{ InitCommand=function(self) self:zoomto(100, 1):y(rh*6):diffuse(1,1,1,0.33) end }

-- itg records
local listargs_itg = {}
for k, v in pairs(listargs) do listargs_itg[k] = v end
listargs_itg.ITG = true
pane[#pane+1] = LoadActor(THEME:GetPathB("", "_modules/HighScoreList_WF.lua"), listargs_itg)..{
	InitCommand = function(self) self:y(rh*6) end
}

return pane